<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// تحقق من تسجيل الدخول
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

require 'config.php';
require __DIR__ . '/vendor/autoload.php';
use Mpdf\Mpdf;

// جلب العملاء والمواد
$customers = $conn->query("SELECT * FROM customers ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
$products  = $conn->query("SELECT * FROM products ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);

$quick_message  = "";
$manual_message = "";

// إنشاء مجلد مؤقت إذا لم يكن موجود
$tmpDir = __DIR__ . '/tmp';
if (!file_exists($tmpDir)) {
    mkdir($tmpDir, 0777, true);
}

// =====================
// معالجة الوصل السريع
// =====================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quick_text'])) {
    $text = $_POST['quick_text'];

    // استخراج الكمية والسعر
    preg_match('/([\d.,]+)\s*(كغ|كجم|قطعة)?/u', $text, $qty_match);
    preg_match('/سعر\s*([\d.,]+)/u', $text, $price_match);

    $quantity = isset($qty_match[1]) ? floatval(str_replace(',', '.', $qty_match[1])) : 1;
    $unit     = $qty_match[2] ?? '';
    $price    = isset($price_match[1]) ? floatval(str_replace(',', '.', $price_match[1])) : 0;

    // إزالة الكمية والسعر من النص
    $remaining = preg_replace('/([\d.,]+\s*(كغ|كجم|قطعة)?|سعر\s*[\d.,]+)/u', '', $text);
    $remaining = trim($remaining);

    // البحث عن العميل بشكل ذكي
    $customer = null;
    $similar_names = [];

    if (!empty($remaining)) {
        foreach ($customers as $c) {
            // التطابق المباشر
            if (stripos($remaining, $c['name']) !== false) {
                $customer = $c;
                break;
            }
            // البحث عن أسماء مشابهة
            $lev = levenshtein(mb_strtolower($remaining), mb_strtolower($c['name']));
            if ($lev <= 5) $similar_names[] = $c['name'];
        }

        if (!$customer) {
            if (!empty($similar_names)) {
                $quick_message = "❌ لم يتم العثور على العميل، هل تقصد: " . implode(" / ", $similar_names) . " ؟";
            } else {
                $quick_message = "❌ لم يتم العثور على العميل.";
            }
        }
    }

    // إذا تم العثور على العميل، أنشئ الوصل
    if ($customer) {
        $product_name = trim(str_replace($customer['name'], '', $remaining));

        // البحث عن المادة أو إضافتها
        $stmt = $conn->prepare("SELECT * FROM products WHERE name LIKE ?");
        $stmt->execute(['%' . $product_name . '%']);
        $product = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$product) {
            $stmt = $conn->prepare("INSERT INTO products (name, price, unit) VALUES (?, 0, ?)");
            $stmt->execute([$product_name, $unit]);
            $product_id = $conn->lastInsertId();
        } else {
            $product_id = $product['id'];
        }

        // إنشاء الوصل
        $stmt = $conn->prepare("INSERT INTO deliveries (customer_id, total) VALUES (?, ?)");
        $stmt->execute([$customer['id'], $price * $quantity]);
        $delivery_id = $conn->lastInsertId();

        $stmt = $conn->prepare("INSERT INTO delivery_items (delivery_id, product_id, quantity, price) VALUES (?, ?, ?, ?)");
        $stmt->execute([$delivery_id, $product_id, $quantity, $price]);

        // توليد PDF
        $mpdf = new Mpdf(['format'=>'A5-L','default_font'=>'dejavusans','tempDir'=>$tmpDir]);
        $random_invoice = rand(1000,9999);
        $date = date('Y-m-d');

        $html = "
        <html lang='ar' dir='rtl'>
        <body style='font-family: dejavusans;'>
        <table width='100%'>
            <tr>
                <td width='50%'><img src='1.jpeg' width='120'></td>
                <td width='50%' style='text-align:right; font-size:12px;'>
                    <strong>ALJAMEEL INTERNATIONAL GIDA SANAYI</strong><br>
                    TEL:05344438000-02124707700<br>
                    ADDRESS: TURKEY- ISTANBUL-BASAKSEHIR<br>
                    GIDA TOPTANCILER SETESI/3 ADA/2A/07_08
                </td>
            </tr>
        </table>
        <hr>
        <h2 style='text-align:center;'>SATIS FATURA</h2>
        <p><strong>العميل:</strong> {$customer['name']}<br>
        <strong>العنوان:</strong> {$customer['address']}<br>
        ".(!empty($customer['phone']) ? "<strong>الهاتف:</strong> {$customer['phone']}<br>" : "")."
        <strong>تاريخ الوصل:</strong> $date<br>
        <strong>رقم الوصل:</strong> $random_invoice
        </p>
        <table border='1' style='width:100%;border-collapse:collapse; font-size:12px;'>
        <tr><th>Ürün</th><th>Miktar</th><th>Fiyat</th><th>Toplam</th></tr>
        <tr>
            <td>$product_name</td>
            <td>$quantity $unit</td>
            <td>$price</td>
            <td>".($quantity*$price)."</td>
        </tr>
        </table>
        <h3>الإجمالي: ".($quantity*$price)." $</h3>
        <p>التوقيع: ________________</p>
        </body>
        </html>
        ";

        $filename = "delivery_quick_{$delivery_id}.pdf";
        $mpdf->WriteHTML($html);
        $mpdf->Output($filename,'I');
        exit;
    }
}

// =====================
// الوصل اليدوي (يبقى كما هو)
// =====================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['manual_customer'])) {
    $customer_id = $_POST['manual_customer'];
    $product_ids = $_POST['product_id'] ?? [];
    $quantities  = $_POST['quantity'] ?? [];
    $prices      = $_POST['price'] ?? [];

    if (!$customer_id || empty($product_ids)) {
        $manual_message = "❌ اختر العميل وأضف المنتجات.";
    } else {
        $total = 0;
        foreach ($product_ids as $k => $pid) {
            $total += $quantities[$k]*$prices[$k];
        }

        $stmt = $conn->prepare("INSERT INTO deliveries (customer_id, total) VALUES (?, ?)");
        $stmt->execute([$customer_id, $total]);
        $delivery_id = $conn->lastInsertId();

        foreach ($product_ids as $k => $pid) {
            $stmt = $conn->prepare("INSERT INTO delivery_items (delivery_id, product_id, quantity, price) VALUES (?, ?, ?, ?)");
            $stmt->execute([$delivery_id, $pid, $quantities[$k], $prices[$k]]);
        }

        $stmt = $conn->prepare("SELECT * FROM customers WHERE id=?");
        $stmt->execute([$customer_id]);
        $customer = $stmt->fetch(PDO::FETCH_ASSOC);

        $mpdf = new Mpdf(['format'=>'A5-L','default_font'=>'dejavusans','tempDir'=>$tmpDir]);
        $random_invoice = rand(1000,9999);
        $date = date('Y-m-d');

        $html = "<html lang='ar' dir='rtl'><body style='font-family: dejavusans;'>
        <table width='100%'>
            <tr>
                <td width='50%'><img src='1.jpeg' width='120'></td>
                <td width='50%' style='text-align:right; font-size:12px;'>
                    <strong>ALJAMEEL INTERNATIONAL GIDA SANAYI</strong><br>
                    TEL:05344438000-02124707700<br>
                    ADDRESS: TURKEY- ISTANBUL-BASAKSEHIR<br>
                    GIDA TOPTANCILER SETESI/3 ADA/2A/07_08
                </td>
            </tr>
        </table>
        <hr>
        <h2 style='text-align:center;'>IRSALİYE</h2>
        <p>
            <strong>Müşteri:</strong> {$customer['name']}<br>
            <strong>Adres:</strong> {$customer['address']}<br>
            ".(!empty($customer['phone']) ? "<strong>Telefon:</strong> {$customer['phone']}<br>" : "")."
            <strong>İrsaliye Tarihi:</strong> $date<br>
            <strong>İrsaliye No:</strong> $random_invoice
        </p>
        <table border='1' style='width:100%;border-collapse:collapse; font-size:12px;'>
        <tr><th>Ürün</th><th>Miktar</th><th>Fiyat</th><th>Toplam</th></tr>";

        foreach ($product_ids as $k => $pid) {
            $stmt = $conn->prepare("SELECT name FROM products WHERE id=?");
            $stmt->execute([$pid]);
            $p = $stmt->fetch(PDO::FETCH_ASSOC);
            $html .= "<tr>
                <td>{$p['name']}</td>
                <td>{$quantities[$k]}</td>
                <td>{$prices[$k]}</td>
                <td>".($quantities[$k]*$prices[$k])."</td>
            </tr>";
        }

        $html .= "</table><h3>Toplam: $total $</h3>
        <p>İmza: ________________</p>
        </body></html>";

        $filename = "delivery_manual_{$delivery_id}.pdf";
        $mpdf->WriteHTML($html);
        $mpdf->Output($filename,'I');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لوحة تحكم Alj</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
body{background:#f5f5f5;}
.card{margin-bottom:20px;}
.list-group-item:hover{cursor:pointer;}
</style>
<script>
function addRow() {
    const table = document.getElementById("manual_items");
    const row = table.insertRow();
    row.innerHTML = `<td>
        <select name="product_id[]" required class="form-select">
            <option value="">اختر مادة</option>
            <?php foreach ($products as $p): ?>
                <option value="<?= htmlspecialchars($p['id']) ?>"><?= htmlspecialchars($p['name']) ?></option>
            <?php endforeach; ?>
        </select></td>
        <td><input type="number" name="quantity[]" class="form-control" step="0.01" required></td>
        <td><input type="number" name="price[]" class="form-control" step="0.01" required placeholder="السعر الخاص بالعميل"></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="this.closest('tr').remove()">✖</button></td>`;
}

$(document).ready(function(){
    $("#manual_customer_search").on("input", function(){
        var query = $(this).val();
        if(query.length >= 2){
            $.ajax({
                url: 'search_customer.php',
                method: 'GET',
                data: {q: query},
                success: function(data){
                    $("#manual_customer_list").html(data);
                }
            });
        } else { $("#manual_customer_list").html(''); }
    });

    $(document).on('click', '.customer-item', function(){
        var name = $(this).text();
        var id = $(this).data('id');
        $("#manual_customer_search").val(name);
        $("#manual_customer_id").val(id);
        $("#manual_customer_list").html('');
    });
});
</script>
</head>
<body class="container mt-4">
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">🏠 الرئيسية</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav">
        <li class="nav-item"><a class="nav-link" href="customers.php">👥 العملاء</a></li>
        <li class="nav-item"><a class="nav-link" href="new_customer.php">➕ إضافة عميل</a></li>
        <li class="nav-item"><a class="nav-link" href="products.php">📦 المنتجات</a></li>
        <li class="nav-item"><a class="nav-link" href="new_product.php">➕ إضافة منتج</a></li>
        <li class="nav-item"><a class="nav-link" href="upload_customers.php">⬆ رفع عملاء</a></li>
        <li class="nav-item"><a class="nav-link" href="upload_products.php">⬆ رفع مواد</a></li>
      </ul>
    </div>
  </div>
</nav>

<h1 class="mb-4">لوحة تحكم Alj</h1>

<div class="mb-3">
    <a href="login.php?logout=1" class="btn btn-danger">🚪 تسجيل الخروج</a>
</div>

<div class="row">
<div class="col-md-6">
    <div class="card shadow">
        <div class="card-header bg-primary text-white">📝 إنشاء وصل يدوي</div>
        <div class="card-body">
            <?php if($manual_message) echo "<div class='alert alert-danger'>$manual_message</div>"; ?>
            <form method="post">
                <div class="mb-3 position-relative">
                    <label>اختر العميل:</label>
                    <input type="text" id="manual_customer_search" class="form-control" placeholder="اكتب اسم العميل" required>
                    <div id="manual_customer_list" class="list-group mt-1"></div>
                    <input type="hidden" name="manual_customer" id="manual_customer_id" required>
                </div>
                <table class="table table-bordered" id="manual_items">
                    <tr><th>المادة</th><th>الكمية</th><th>السعر</th><th>حذف</th></tr>
                </table>
                <button type="button" class="btn btn-secondary mb-2" onclick="addRow()">➕ إضافة مادة</button>
                <button type="submit" class="btn btn-success w-100">💾 إنشاء PDF</button>
            </form>
        </div>
    </div>
</div>

<div class="col-md-6">
    <div class="card shadow">
        <div class="card-header bg-warning text-dark">⚡ إنشاء وصل سريع</div>
        <div class="card-body">
            <?php if($quick_message) echo "<div class='alert alert-danger'>$quick_message</div>"; ?>
            <form method="post">
                <div class="mb-3">
                    <textarea name="quick_text" class="form-control" rows="3" placeholder="مثال: 600 كغ جوز هند كامل اندونيسي سعر 4.400$ شركة الشرباتي" required></textarea>
                </div>
                <button class="btn btn-success w-100">💾 إنشاء PDF وصل سريع</button>
            </form>
        </div>
    </div>
</div>
</div>
</body>
</html>
